package it.eng.eremita.jpa.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="MAIN_VALORE_METADATO")
@SequenceGenerator(name="SEQ_VALORE_METADATO", sequenceName="SEQ_VALORE_METADATO", initialValue=1, allocationSize=1)
public class ValoreMetadato {
	
	Long id;
	String tipoEntita;
	Long idEntita;
	Metadato metadato;
	String valore;
	
	@Id
	@GeneratedValue(strategy=GenerationType.SEQUENCE,generator="SEQ_VALORE_METADATO")
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	
	@Column(name="TIPO_ENTITA")
	public String getTipoEntita() {
		return tipoEntita;
	}
	public void setTipoEntita(String tipoEntita) {
		this.tipoEntita = tipoEntita;
	}
	
	@Column(name="ID_ENTITA")
	public Long getIdEntita() {
		return idEntita;
	}
	public void setIdEntita(Long idEntita) {
		this.idEntita = idEntita;
	}
	
	@ManyToOne
	@JoinColumn(name="METADATO")
	public Metadato getMetadato() {
		return metadato;
	}
	public void setMetadato(Metadato metadato) {
		this.metadato = metadato;
	}
	
	@Column(name="VALORE")
	public String getValore() {
		return valore;
	}
	public void setValore(String valore) {
		this.valore = valore;
	}
	
	

}
